/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.world.biome;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.LongFunction;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import potionstudios.byg.mixin.access.WeightedListAccess;
import terrablender.worldgen.noise.Area;
import terrablender.worldgen.noise.AreaContext;
import terrablender.worldgen.noise.AreaFactory;
import terrablender.worldgen.noise.AreaTransformer0;
import terrablender.worldgen.noise.AreaTransformer1;
import terrablender.worldgen.noise.LayeredNoiseUtil;
import terrablender.worldgen.noise.ZoomLayer;

public class LayerUtil {
    public static Area createLayers(class_2378<class_1959> biomeRegistry, long worldSeed, class_6005<class_5321<class_1959>> biomes, int regionSize, Path configPath) {
        LongFunction<AreaContext> contextFactory = seedModifier -> new AreaContext(25, worldSeed, seedModifier);
        AreaFactory factory = new InitLayer(biomes, biomeRegistry, configPath).run(contextFactory.apply(1L));
        factory = ZoomLayer.FUZZY.run(contextFactory.apply(2000L), factory);
        factory = LayeredNoiseUtil.zoom((long)2001L, (AreaTransformer1)ZoomLayer.FUZZY, (AreaFactory)factory, (int)3, contextFactory);
        factory = LayeredNoiseUtil.zoom((long)1001L, (AreaTransformer1)ZoomLayer.NORMAL, (AreaFactory)factory, (int)regionSize, contextFactory);
        return factory.make();
    }

    private static class InitLayer
    implements AreaTransformer0 {
        private final class_6005<class_5321<class_1959>> biomes;
        private final class_2378<class_1959> biomeRegistry;
        private final Path path;
        private final int totalWeight;
        private final List<class_6008> entries;

        public InitLayer(class_6005<class_5321<class_1959>> biomes, class_2378<class_1959> biomeRegistry, Path path) {
            this.biomes = biomes;
            this.biomeRegistry = biomeRegistry;
            this.path = path;
            this.totalWeight = ((WeightedListAccess)this.biomes).byg_getTotalWeight();
            this.entries = ((WeightedListAccess)this.biomes).byg_getItems();
        }

        public int apply(AreaContext areaContext, int x, int z) {
            if (this.totalWeight == 0) {
                return this.biomeRegistry.method_10206((Object)((class_1959)this.biomeRegistry.method_29107(class_1972.field_9423)));
            }
            Optional weightedItem = class_6011.method_34985(this.entries, (int)areaContext.nextRandom(this.totalWeight));
            class_6008.class_6010 resourceKeyWrapper = (class_6008.class_6010)weightedItem.get();
            class_5321 key = (class_5321)resourceKeyWrapper.method_34983();
            if (!this.biomeRegistry.method_35842(key)) {
                throw new IllegalArgumentException(String.format("\"%s\" is not a valid biome in the registry, fix the ID or remove the json entry from the config: \"%s\" and relaunch Minecraft...", key, this.path));
            }
            return this.biomeRegistry.method_10206((Object)((class_1959)this.biomeRegistry.method_29107((class_5321)resourceKeyWrapper.method_34983())));
        }
    }
}

